# 静态资源目录

## 📁 目录说明

此目录用于存放应用的静态资源文件，包括Logo、背景图片、图标等。

## 🖼️ 支持的文件类型

### Logo文件
- **格式**：PNG, JPG, JPEG, SVG
- **推荐尺寸**：120x120px (高分辨率设备使用240x240px)
- **命名建议**：
  - `logo.png` - 默认Logo
  - `company-logo.png` - 公司Logo
  - `laser-logo.png` - 激光设备Logo
  - `cnc-logo.png` - CNC设备Logo

### 背景图片
- **格式**：JPG, JPEG, PNG
- **推荐尺寸**：1920x1080px 或更高分辨率
- **命名建议**：
  - `background.jpg` - 默认背景
  - `laser-bg.jpg` - 激光主题背景
  - `industrial-bg.jpg` - 工业主题背景

### 图标文件
- **格式**：PNG, SVG
- **推荐尺寸**：32x32px, 64x64px
- **用途**：按钮图标、状态指示器等

## 📋 文件命名规范

### Logo文件命名
```
logo.png                    # 默认Logo
[设备类型]-logo.png         # 特定设备Logo
[公司名称]-logo.png         # 公司Logo
```

### 背景图片命名
```
background.jpg              # 默认背景
[主题名称]-bg.jpg          # 主题背景
[设备类型]-background.jpg   # 设备专用背景
```

### 图标文件命名
```
icon-[功能名称].png         # 功能图标
status-[状态名称].png       # 状态图标
```

## 🎨 设计指南

### Logo设计要求
1. **清晰度**：确保在小尺寸下依然清晰可见
2. **对比度**：与应用主题色彩搭配协调
3. **格式**：优先使用PNG格式以获得最佳效果
4. **透明背景**：建议使用透明背景的PNG文件

### 背景图片设计要求
1. **分辨率**：至少1920x1080px
2. **色彩**：避免过于鲜艳的颜色，以免影响按钮可读性
3. **对比度**：确保按钮文字在背景上清晰可见
4. **文件大小**：控制在2MB以内以确保加载速度

## 📝 使用示例

### 在配置文件中引用资源

```javascript
// 配置Logo
appInfo: {
  logoPath: "/static/your-company-logo.png"
}

// 配置背景图片
theme: {
  backgroundImage: "/static/industrial-background.jpg"
}

// 配置按钮图标
buttons: [
  {
    text: "启动",
    type: "green", 
    action: "start",
    icon: "▶️"  // 可以使用Emoji或引用图片文件
  }
]
```

### 图片文件路径规则

所有静态资源的路径都以 `/static/` 开头：

```
/static/logo.png                    ✅ 正确
/static/backgrounds/laser-bg.jpg    ✅ 正确
static/logo.png                     ❌ 错误（缺少开头的斜杠）
./static/logo.png                   ❌ 错误（不要使用相对路径）
```

## 🗂️ 推荐目录结构

```
static/
├── logos/                  # Logo文件目录
│   ├── default-logo.png
│   ├── laser-logo.png
│   ├── cnc-logo.png
│   └── company-logo.png
├── backgrounds/            # 背景图片目录
│   ├── default-bg.jpg
│   ├── laser-bg.jpg
│   ├── industrial-bg.jpg
│   └── modern-bg.jpg
├── icons/                  # 图标文件目录
│   ├── start-icon.png
│   ├── stop-icon.png
│   └── settings-icon.png
└── README.md              # 本说明文件
```

## 🔧 优化建议

### 文件大小优化
1. **压缩图片**：使用在线工具或图片编辑软件压缩图片
2. **选择合适格式**：
   - Logo: PNG (支持透明)
   - 照片背景: JPG (文件更小)
   - 简单图标: SVG (矢量格式)

### 性能优化
1. **预加载**：将常用图片预先加载到缓存
2. **懒加载**：对于大型背景图片考虑懒加载
3. **CDN**：对于生产环境，考虑使用CDN加速图片加载

## 📱 多设备适配

### 响应式图片
为不同分辨率的设备准备多个尺寸的图片：

```
logos/
├── logo-120.png           # 标准分辨率 120x120
├── logo-240.png           # 高分辨率 240x240
└── logo.svg               # 矢量格式（推荐）
```

### 配置示例
```javascript
appInfo: {
  logoPath: "/static/logos/logo.svg"  // SVG自动适配所有分辨率
}
```

## 🚨 注意事项

### 版权问题
- 确保使用的图片拥有合法使用权
- 避免使用有版权的商标或图片
- 优先使用自己创作或免费素材

### 文件安全
- 只上传图片文件，避免上传可执行文件
- 检查文件扩展名和MIME类型
- 定期清理不使用的文件

### 兼容性
- 测试图片在不同设备和分辨率下的显示效果
- 确保图片在暗色和亮色主题下都能正常显示
- 验证图片加载失败时的备用方案

## 🔄 更新流程

### 更换Logo
1. 将新Logo文件上传到 `static/` 目录
2. 在配置文件中更新Logo路径
3. 重新加载应用验证效果

### 更换背景
1. 将新背景图片上传到 `static/` 目录  
2. 在主题配置中更新背景图片路径
3. 测试按钮可读性和整体效果

---

通过合理组织和优化静态资源，可以大大提升应用的视觉效果和用户体验。 