// setting.js
Page({
  data: {
    serverUrl: '',
    deviceId: '',
    timeout: 30,
    stepDistance: 1.0
  },

  onLoad() {
    // 加载本地存储的设置
    this.loadSettings()
  },

  // 返回上一页
  goBack() {
    ft.navigateBack();
  },

  // 加载设置
  loadSettings() {
    const serverUrl = ft.getStorageSync('serverUrl') || ''
    const deviceId = ft.getStorageSync('deviceId') || ''
    const timeout = ft.getStorageSync('timeout') || 30
    const stepDistance = ft.getStorageSync('stepDistance') || 1.0

    this.setData({
      serverUrl,
      deviceId,
      timeout,
      stepDistance
    })
  },

  // 服务器地址输入
  onServerUrlChange(e) {
    this.setData({
      serverUrl: e.detail.value
    })
  },

  // 设备ID输入
  onDeviceIdChange(e) {
    this.setData({
      deviceId: e.detail.value
    })
  },

  // 超时时间输入
  onTimeoutChange(e) {
    this.setData({
      timeout: e.detail.value
    })
  },

  // 步进距离输入
  onStepDistanceChange(e) {
    this.setData({
      stepDistance: e.detail.value
    })
  },

  // 保存设置
  saveSetting() {
    const { serverUrl, deviceId, timeout, stepDistance } = this.data

    if (!serverUrl.trim()) {
      ft.showToast({
        icon: 'error',
        title: '请输入服务器地址'
      })
      return
    }

    if (!deviceId.trim()) {
      ft.showToast({
        icon: 'error',
        title: '请输入设备ID'
      })
      return
    }

    const stepDistanceNum = parseFloat(stepDistance)
    if (isNaN(stepDistanceNum) || stepDistanceNum <= 0) {
      ft.showToast({
        icon: 'error',
        title: '请输入有效的步进距离'
      })
      return
    }

    try {
      ft.setStorageSync('serverUrl', serverUrl.trim())
      ft.setStorageSync('deviceId', deviceId.trim())
      ft.setStorageSync('timeout', parseInt(timeout) || 30)
      ft.setStorageSync('stepDistance', stepDistanceNum)

      ft.showToast({
        icon: 'success',
        title: '保存成功',
        success: () => {
          setTimeout(() => {
            ft.navigateBack()
          }, 1500)
        }
      })
    } catch (error) {
      ft.showToast({
        icon: 'error',
        title: '保存失败'
      })
    }
  }
}) 