// config/examples/simple-config.js
// 简化版配置示例 - 适合初学者或基础控制需求

const SimpleConfig = {
  // 应用基础信息
  appInfo: {
    appName: "我的设备控制器",
    version: "1.0.0",
    developer: "您的公司",
    logoPath: "/static/logo.png"
  },

  // 简单主题
  theme: {
    primaryColor: "#2196F3",
    buttonColors: {
      green: "#4CAF50",    // 启动按钮
      red: "#F44336",      // 停止按钮
      blue: "#2196F3",     // 功能按钮
      gray: "#9E9E9E",     // 普通按钮
      white: "#FFFFFF"     // 方向按钮
    }
  },

  // 默认设置
  defaults: {
    serverUrl: "192.168.1.100:8080",
    deviceId: "DEVICE_001",
    stepDistance: 1.0
  },

  // 简单的4x4按钮布局
  buttonLayout: {
    gridColumns: 4,
    buttons: [
      // 第一行 - 基本控制
      { text: "启动", type: "green", action: "start" },
      { text: "停止", type: "red", action: "stop" },
      { text: "暂停", type: "gray", action: "pause" },
      { text: "复位", type: "gray", action: "reset" },
      
      // 第二行 - 方向控制（上）
      { text: "", type: "gray" },
      { arrow: true, type: "white", rotation: 0, action: "moveUp" },
      { text: "", type: "gray" },
      { text: "高速", type: "blue", action: "highSpeed" },
      
      // 第三行 - 方向控制（左右）
      { arrow: true, type: "white", rotation: -90, action: "moveLeft" },
      { text: "回零", type: "blue", action: "home" },
      { arrow: true, type: "white", rotation: 90, action: "moveRight" },
      { text: "低速", type: "gray", action: "lowSpeed" },
      
      // 第四行 - 方向控制（下）
      { text: "", type: "gray" },
      { arrow: true, type: "white", rotation: 180, action: "moveDown" },
      { text: "", type: "gray" },
      { text: "步进", type: "gray", action: "step" }
    ]
  },

  // 基础API配置
  apiConfig: {
    basePath: "/api",
    endpoints: {
      start: "/start",
      stop: "/stop",
      pause: "/pause",
      reset: "/reset",
      move: "/move",
      home: "/home"
    }
  },

  // 简单动作映射
  actionMapping: {
    start: { type: "api", method: "startMachine", successMessage: "设备启动" },
    stop: { type: "api", method: "stopMachine", successMessage: "设备停止" },
    pause: { type: "api", method: "pauseMachine", successMessage: "设备暂停" },
    reset: { type: "api", method: "resetMachine", successMessage: "设备复位" },
    
    // 移动控制
    moveUp: { type: "continuous", startMethod: "moveAxisUp", stopMethod: "stopAxis", stopParams: [1] },
    moveDown: { type: "continuous", startMethod: "moveAxisDown", stopMethod: "stopAxis", stopParams: [1] },
    moveLeft: { type: "continuous", startMethod: "moveAxisLeft", stopMethod: "stopAxis", stopParams: [0] },
    moveRight: { type: "continuous", startMethod: "moveAxisRight", stopMethod: "stopAxis", stopParams: [0] },
    
    // 其他功能
    home: { type: "api", method: "homeAll", successMessage: "回到原点" },
    highSpeed: { type: "toggle", property: "isRapidMode", value: true, successMessage: "高速模式" },
    lowSpeed: { type: "toggle", property: "isRapidMode", value: false, successMessage: "低速模式" },
    step: { type: "menu", method: "showStepMenu" }
  },

  // 侧边菜单
  sideMenu: {
    items: [
      { text: "设置", icon: "⚙️", url: "../setting/setting" },
      { text: "关于", icon: "ℹ️", url: "../about/about" }
    ]
  },

  // 功能开关
  features: {
    vibration: true,
    connectionCheck: true,
    stepControl: true
  }
}

module.exports = SimpleConfig 