/**
 * 应用配置文件 - Application Configuration
 * 用户可以通过修改此文件来自定义界面和功能
 * Users can customize interface and functionality by modifying this file
 */

const AppConfig = {
  // 应用基本信息 - App Basic Information
  app: {
    name: '虚拟键盘',           // Application name
    version: '1.0.0',          // Version number
    developer: 'xEOS+xAPP Team', // Developer name
    description: '虚拟键盘是一款专为 xEOS+xAPP 平台设计的智能输入工具。它提供了直观易用的触屏键盘界面，支持多种输入模式，能够满足用户在不同场景下的输入需求。应用采用现代化的设计语言，注重用户体验和界面美观。',
    releaseDate: '2024-01-01',
    logo: '/static/logo.png'    // App logo path
  },

  // UI主题配置 - UI Theme Configuration
  theme: {
    // 主色调 - Primary Colors
    primary: {
      background: 'linear-gradient(135deg, #323844 0%, #2c3e50 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(255,255,255,0.15), rgba(255,255,255,0.08))',
      textPrimary: '#ffffff',
      textSecondary: '#bdc3c7',
      accent: '#3498db'
    },
    
    // 按钮颜色 - Button Colors
    buttonColors: {
      green: '#27ae60',
      red: '#e74c3c', 
      blue: '#3498db',
      yellow: '#f1c40f',
      brown: '#8b4513',
      gray: '#7f8c8d',
      white: '#ecf0f1'
    },

    // 背景图片 - Background Image
    backgroundImage: '/static/bg.jpg',
    
    // 毛玻璃效果 - Glass Effect
    glassEffect: {
      backdropFilter: 'blur(15rpx)',
      border: '1rpx solid rgba(255,255,255,0.1)',
      shadow: '0 8rpx 32rpx rgba(0,0,0,0.3)'
    }
  },

  // 默认设置 - Default Settings
  defaults: {
    serverUrl: '',
    deviceId: 'DEVICE_001',
    timeout: 30,
    stepDistance: 1.0,
    isRapidMode: false
  },

  // 按钮布局配置 - Button Layout Configuration
  buttonLayout: {
    gridColumns: 8,  // 网格列数 - Grid columns
    gridRows: 4,     // 网格行数 - Grid rows
    
    // 按钮定义 - Button Definitions
    buttons: [
      // 第一行 - Row 1
      { text: '开始', type: 'green', action: 'start', icon: '▶️' },
      { text: '暂停', type: 'brown', action: 'pause', icon: '⏸️' },
      { text: '继续', type: 'blue', action: 'continue', icon: '⏯️' },
      { text: '停止', type: 'red', action: 'stop', icon: '⏹️' },
      { text: '吹气', type: 'white', action: 'blow', icon: '💨' },
      { text: '跟随', type: 'white', action: 'follow', icon: '👥' },
      { text: '清除\n报警', type: 'white', action: 'clearAlarm', icon: '🚨' },
      { text: '红光', type: 'white', action: 'redLight', icon: '🔴' },
      
      // 第二行 - Row 2
      { text: '断点\n定位', type: 'white', action: 'breakpointPos', icon: '📍' },
      { text: '回退', type: 'white', action: 'backward', icon: '⏪' },
      { text: '前进', type: 'white', action: 'forward', icon: '⏩' },
      { text: '激光\n点射', type: 'yellow', action: 'laserPulse', icon: '⚡' },
      { text: 'K1', type: 'blue', action: 'k1', icon: '1️⃣' },
      { text: 'K2', type: 'blue', action: 'k2', icon: '2️⃣' },
      { text: 'K3', type: 'blue', action: 'k3', icon: '3️⃣' },
      { text: 'K4', type: 'blue', action: 'k4', icon: '4️⃣' },
      
      // 第三行 - Row 3
      { text: '寻边', type: 'blue', showFn: true, action: 'findEdge', icon: '🔍' },
      { text: '一键\n交换', type: 'blue', showFn: true, action: 'quickSwap', icon: '🔄' },
      { text: '标定', type: 'gray', action: 'calibrate', icon: '📐' },
      { text: 'Fn', type: 'blue', action: 'fn', icon: '⚙️' },
      { text: '空运行', type: 'blue', showFn: true, action: 'dryRun', icon: '🏃' },
      { arrow: true, type: 'white', rotation: 0, action: 'moveUp', icon: '⬆️' },
      { zAxis: true, type: 'gray', rotation: 0, action: 'zUp', icon: '🔼' },
      { text: '低速', type: 'gray', action: 'lowSpeed', icon: '🐌' },
      
      // 第四行 - Row 4
      { arrow: true, type: 'white', rotation: -90, action: 'moveLeft', icon: '⬅️' },
      { text: '工作\n零点', type: 'blue', showFn: true, action: 'workZero', icon: '🎯' },
      { arrow: true, type: 'white', rotation: 90, action: 'moveRight', icon: '➡️' },
      { text: '高速', type: 'yellow', action: 'highSpeed', icon: '🚀' },
      { text: '走边框', type: 'blue', showFn: true, action: 'walkBorder', icon: '🔲' },
      { arrow: true, type: 'white', rotation: 180, action: 'moveDown', icon: '⬇️' },
      { zAxis: true, type: 'gray', rotation: 180, action: 'zDown', icon: '🔽' },
      { text: '步进', type: 'gray', action: 'step', icon: '📏' }
    ]
  },

  // API端点配置 - API Endpoint Configuration
  api: {
    // 基础路径 - Base Path
    basePath: '/api/MachineControl',
    
    // 端点定义 - Endpoint Definitions
    endpoints: {
      controlMachine: '/ControlMachineStatus',
      controlAxisInchMove: '/ControlAxisInchMove', 
      controlAxis: '/ControlAxis',
      enableDriver: '/EnableDriver',
      backZeroPoint: '/BackZeroPoint',
      health: '/api/health'
    },
    
    // 请求配置 - Request Configuration
    requestConfig: {
      timeout: 5000,
      retryTimes: 3,
      retryDelay: 1000
    },
    
    // 限流配置 - Rate Limiting
    rateLimit: {
      controlMachine: 5,    // 5 req/s
      controlAxis: 30,      // 30 req/s
      default: 10           // 10 req/s
    }
  },

  // 动作映射配置 - Action Mapping Configuration
  actionMappings: {
    // 设备控制 - Machine Control
    start: {
      type: 'api',
      method: 'startMachine',
      successMessage: '设备启动',
      confirmRequired: false
    },
    pause: {
      type: 'api', 
      method: 'pauseMachine',
      successMessage: '设备暂停',
      confirmRequired: false
    },
    continue: {
      type: 'api',
      method: 'continueMachine', 
      successMessage: '设备继续',
      confirmRequired: false
    },
    stop: {
      type: 'api',
      method: 'stopMachine',
      successMessage: '设备停止',
      confirmRequired: true,
      confirmMessage: '确定要停止设备吗？',
      additionalActions: ['stopAllAxes']
    },
    
    // 运动控制 - Motion Control
    moveUp: {
      type: 'continuous',
      startMethod: 'moveAxisUp',
      stopMethod: 'stopAxis',
      stopParams: [1]
    },
    moveDown: {
      type: 'continuous', 
      startMethod: 'moveAxisDown',
      stopMethod: 'stopAxis',
      stopParams: [1]
    },
    moveLeft: {
      type: 'continuous',
      startMethod: 'moveAxisLeft', 
      stopMethod: 'stopAxis',
      stopParams: [0]
    },
    moveRight: {
      type: 'continuous',
      startMethod: 'moveAxisRight',
      stopMethod: 'stopAxis', 
      stopParams: [0]
    },
    zUp: {
      type: 'continuous',
      startMethod: 'moveZAxisUp',
      stopMethod: 'stopAxis',
      stopParams: [2]
    },
    zDown: {
      type: 'continuous',
      startMethod: 'moveZAxisDown', 
      stopMethod: 'stopAxis',
      stopParams: [2]
    },
    
    // 模式控制 - Mode Control
    highSpeed: {
      type: 'toggle',
      property: 'isRapidMode',
      value: true,
      successMessage: '高速模式'
    },
    lowSpeed: {
      type: 'toggle',
      property: 'isRapidMode', 
      value: false,
      successMessage: '低速模式'
    },
    
    // 特殊功能 - Special Functions
    workZero: {
      type: 'api',
      method: 'backToOriginAll',
      successMessage: '所有轴回原点',
      confirmRequired: true,
      confirmMessage: '确定要回原点吗？'
    },
    step: {
      type: 'menu',
      method: 'showStepMenu'
    },
    
    // 自定义功能 - Custom Functions
    blow: {
      type: 'custom',
      method: 'customBlow',
      successMessage: '执行吹气'
    },
    follow: {
      type: 'custom', 
      method: 'customFollow',
      successMessage: '执行跟随'
    }
  },

  // 侧边菜单配置 - Side Menu Configuration
  sideMenu: {
    items: [
      { text: '设置', icon: '⚙️', url: '../setting/setting' },
      { text: '关于', icon: 'ℹ️', url: '../about/about' }
    ]
  },

  // 功能开关 - Feature Toggles
  features: {
    vibration: true,           // 触觉反馈
    soundFeedback: false,      // 声音反馈
    connectionCheck: true,     // 连接状态检查
    autoSave: true,           // 自动保存设置
    debugMode: false,         // 调试模式
    customActions: true       // 自定义动作支持
  }
}

module.exports = AppConfig 