# 配置系统使用说明

## 📋 概述

本项目提供了灵活的配置系统，允许用户完全自定义虚拟键盘的界面和功能。您可以根据不同的设备类型和使用场景选择合适的配置。

## 🗂️ 配置文件结构

```
config/
├── app-config.js       # 主配置文件（当前使用的配置）
├── configManager.js    # 配置管理器
├── examples/           # 配置示例目录
│   ├── laser-config.js    # 激光切割机配置示例
│   ├── simple-config.js   # 简化配置示例
│   ├── cnc-config.js      # CNC机床配置示例（可自行创建）
│   └── 3dprinter-config.js # 3D打印机配置示例（可自行创建）
└── USAGE.md           # 本使用说明
```

## 🚀 快速开始

### 1. 选择合适的配置模板

根据您的设备类型选择合适的配置模板：

- **激光切割机**：使用 `examples/laser-config.js`
- **简单控制**：使用 `examples/simple-config.js`
- **自定义设备**：复制示例文件进行修改

### 2. 应用配置

#### 方法一：直接替换主配置文件

```bash
# 复制激光配置为主配置
cp config/examples/laser-config.js config/app-config.js

# 或复制简化配置为主配置
cp config/examples/simple-config.js config/app-config.js
```

#### 方法二：修改主配置文件

打开 `config/app-config.js`，将所需配置的内容复制粘贴到主配置文件中。

### 3. 自定义配置

1. 复制一个示例配置文件
2. 根据您的需求修改配置内容
3. 保存为主配置文件

## 🎨 配置定制指南

### 1. 修改应用信息

```javascript
appInfo: {
  appName: "您的应用名称",      // 修改为您的应用名称
  version: "1.0.0",           // 版本号
  developer: "您的公司名称",   // 开发者信息
  logoPath: "/static/your-logo.png" // 您的Logo路径
}
```

### 2. 自定义主题

```javascript
theme: {
  primaryColor: "#FF5722",    // 主色调
  buttonColors: {
    green: "#4CAF50",         // 绿色按钮（通常用于启动）
    red: "#F44336",           // 红色按钮（通常用于停止）
    blue: "#2196F3",          // 蓝色按钮（功能按钮）
    // 添加更多颜色...
  }
}
```

### 3. 配置按钮布局

```javascript
buttonLayout: {
  gridColumns: 6,             // 网格列数
  buttons: [
    { 
      text: "启动",           // 按钮文字
      type: "green",          // 按钮颜色类型
      action: "start",        // 按钮动作
      icon: "▶️"             // 按钮图标（可选）
    },
    // 添加更多按钮...
  ]
}
```

### 4. 自定义动作映射

```javascript
actionMapping: {
  start: {
    type: "api",                    // 动作类型
    method: "startMachine",         // API方法
    successMessage: "设备已启动"    // 成功提示
  },
  // 添加更多动作...
}
```

## 🔧 配置类型说明

### 按钮类型

1. **文字按钮**
   ```javascript
   { text: "启动", type: "green", action: "start" }
   ```

2. **箭头按钮**
   ```javascript
   { arrow: true, type: "white", rotation: 0, action: "moveUp" }
   ```
   - `rotation`: 0=上, 90=右, 180=下, -90=左

3. **Z轴按钮**
   ```javascript
   { zAxis: true, type: "gray", rotation: 0, action: "zUp" }
   ```

4. **空白按钮**
   ```javascript
   { text: "", type: "gray" }
   ```

### 动作类型

1. **API调用**：执行一次API请求
   ```javascript
   { type: "api", method: "startMachine" }
   ```

2. **持续动作**：按住时持续执行，松开时停止
   ```javascript
   { type: "continuous", startMethod: "moveAxisUp", stopMethod: "stopAxis" }
   ```

3. **状态切换**：切换页面数据状态
   ```javascript
   { type: "toggle", property: "isRapidMode", value: true }
   ```

4. **菜单显示**：显示操作菜单
   ```javascript
   { type: "menu", method: "showStepMenu" }
   ```

5. **自定义动作**：执行自定义方法
   ```javascript
   { type: "custom", method: "customBlow" }
   ```

## 📱 Logo和资源配置

### 1. 添加Logo

1. 将Logo文件放在 `static/` 目录下
2. 支持格式：PNG, JPG, SVG
3. 推荐尺寸：120x120px
4. 在配置中设置路径：
   ```javascript
   appInfo: {
     logoPath: "/static/your-logo.png"
   }
   ```

### 2. 添加背景图片

1. 将背景图片放在 `static/` 目录下
2. 在主题配置中设置：
   ```javascript
   theme: {
     backgroundImage: "/static/your-background.jpg"
   }
   ```

## 🔄 配置热更新

### 1. 运行时更新配置

```javascript
// 在页面中更新配置
configManager.set('theme.primaryColor', '#FF5722')
configManager.applyTheme(this)
```

### 2. 保存自定义配置

```javascript
// 保存当前配置到本地存储
configManager.saveCustomConfig()
```

### 3. 重置配置

```javascript
// 重置为默认配置
configManager.resetToDefaults()
```

## 📋 预设配置说明

### 激光切割机配置 (laser-config.js)

- **特点**：深色主题，橙红色调，激光安全功能
- **按钮**：36个按钮，包含激光控制、文件操作、安全功能
- **适用**：激光切割设备、激光雕刻机

**主要功能**：
- 激光开关控制
- 功率设置
- 红光定位
- 安全确认机制
- 文件加载和预览

### 简化配置 (simple-config.js)

- **特点**：4x4布局，基础功能，易于使用
- **按钮**：16个按钮，覆盖基本控制需求
- **适用**：简单设备、初学者、基础控制需求

**主要功能**：
- 基本设备控制（启动/停止/暂停）
- 方向移动控制
- 速度切换
- 步进控制

## 🛠️ 自定义配置模板

### CNC机床配置模板

```javascript
const CNCConfig = {
  appInfo: {
    appName: "CNC控制台",
    logoPath: "/static/cnc-logo.png"
  },
  theme: {
    primaryColor: "#607D8B",  // 蓝灰色主题
    buttonColors: {
      green: "#4CAF50",
      red: "#F44336", 
      blue: "#2196F3",
      orange: "#FF9800"       // 主轴控制
    }
  },
  buttonLayout: {
    buttons: [
      { text: "主轴启动", type: "orange", action: "spindleOn" },
      { text: "主轴停止", type: "gray", action: "spindleOff" },
      { text: "冷却液", type: "blue", action: "coolant" },
      // 更多CNC特定按钮...
    ]
  }
}
```

### 3D打印机配置模板

```javascript
const PrinterConfig = {
  appInfo: {
    appName: "3D打印控制台",
    logoPath: "/static/printer-logo.png"
  },
  theme: {
    primaryColor: "#4CAF50",  // 绿色主题
    buttonColors: {
      green: "#4CAF50",
      red: "#F44336",
      blue: "#2196F3", 
      orange: "#FF9800"       // 加热控制
    }
  },
  buttonLayout: {
    buttons: [
      { text: "热床加热", type: "orange", action: "bedHeat" },
      { text: "喷头加热", type: "orange", action: "nozzleHeat" },
      { text: "挤出", type: "blue", action: "extrude" },
      // 更多3D打印特定按钮...
    ]
  }
}
```

## 🚨 注意事项

### 1. 配置文件语法

- 确保JavaScript语法正确
- 所有字符串使用引号包围
- 对象和数组结构正确
- 注意逗号和括号匹配

### 2. 图片资源

- Logo和背景图片必须放在 `static/` 目录下
- 图片路径以 `/static/` 开头
- 确保图片文件存在且可访问

### 3. API端点配置

- 确保API端点与您的设备服务器匹配
- 检查端点路径的正确性
- 验证服务器地址配置

### 4. 功能开关

- 根据设备能力启用或禁用相关功能
- 测试功能开关是否正常工作

## 🔍 故障排除

### 常见问题

1. **界面显示异常**
   - 检查配置文件语法
   - 确认图片路径正确
   - 查看浏览器控制台错误

2. **按钮不响应**
   - 检查动作映射配置
   - 确认API端点正确
   - 查看网络请求状态

3. **配置不生效**
   - 确认配置文件已保存
   - 重启应用重新加载配置
   - 检查配置文件路径

### 调试技巧

1. **启用调试模式**
   ```javascript
   features: {
     debugMode: true,
     verboseLogging: true
   }
   ```

2. **查看控制台日志**
   - 打开浏览器开发者工具
   - 查看Console面板的日志信息

3. **验证配置加载**
   ```javascript
   console.log('当前配置:', configManager.getAll())
   ```

## 📞 技术支持

如果您在配置过程中遇到问题，请：

1. 检查本文档的故障排除部分
2. 查看项目README.md的详细说明
3. 联系技术支持团队

---

通过本配置系统，您可以创建完全符合自己需求的虚拟键盘控制界面。建议从简单配置开始，逐步添加更多功能。 