# 虚拟键盘控制应用 - 自定义指南

## 📱 项目简介

这是一个基于FinClip小程序的虚拟键盘控制应用，支持完全自定义的界面布局、按钮映射和主题配置。用户可以根据自己的设备和需求，创建个性化的控制界面。

## 🚀 快速开始

### 基础配置

1. **配置服务器地址**：在设置页面中配置您的设备服务器地址
2. **设备ID**：输入对应的设备ID
3. **连接超时**：设置合适的连接超时时间
4. **步进距离**：配置轴移动的步进距离

### 项目结构

```
virtual-keyboard/
├── app.js              # 应用程序入口
├── app.json            # 应用配置
├── config/
│   └── app-config.js   # 应用配置文件 (主要自定义文件)
├── pages/
│   ├── index/          # 主页面
│   ├── setting/        # 设置页面
│   └── about/          # 关于页面
├── utils/
│   ├── configManager.js    # 配置管理器
│   └── motionControlApi.js # 运动控制API
├── static/             # 静态资源 (图片、logo等)
└── README.md          # 本文档
```

## 🎨 界面自定义

### 1. 基础信息自定义

编辑 `config/app-config.js` 文件中的应用基础信息：

```javascript
appInfo: {
  appName: "您的应用名称",           // 应用名称
  version: "2.0.0",                // 版本号
  developer: "您的公司/姓名",       // 开发者信息
  description: "应用描述",         // 应用描述
  releaseDate: "2024-01-01",       // 发布日期
  logoPath: "/static/your-logo.png" // Logo路径
}
```

### 2. 添加自定义Logo

1. 将您的Logo文件放在 `static/` 目录下
2. 支持的格式：PNG, JPG, SVG
3. 推荐尺寸：120x120px（高分辨率设备请使用240x240px）
4. 在配置文件中设置Logo路径：

```javascript
appInfo: {
  logoPath: "/static/your-company-logo.png"
}
```

### 3. 多主题背景色彩系统

#### 开发者主题配置

应用内置了多种精美的主题色彩方案，**开发者可以通过修改配置文件来设置应用主题**：

```javascript
theme: {
  currentTheme: 'premiumPurple', // 开发者设置的默认主题
  
  themes: {
    // 🔷 科技蓝主题 - 专业科技感
    techBlue: {
      name: '科技蓝',
      background: 'linear-gradient(135deg, #1e3c72 0%, #2a5298 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(33, 150, 243, 0.2), rgba(25, 118, 210, 0.15))',
      textPrimary: '#ffffff',
      textSecondary: '#bbdefb',
      accent: '#64b5f6'
    },
    
    // 🟠 工业橙主题 - 工业制造风格
    industrialOrange: {
      name: '工业橙',
      background: 'linear-gradient(135deg, #bf360c 0%, #e65100 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(255, 87, 34, 0.2), rgba(230, 81, 0, 0.15))',
      textPrimary: '#ffffff',
      textSecondary: '#ffccbc',
      accent: '#ff8a65'
    },
    
    // 🟢 环保绿主题 - 自然环保风格
    ecoGreen: {
      name: '环保绿',
      background: 'linear-gradient(135deg, #1b5e20 0%, #2e7d32 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(76, 175, 80, 0.2), rgba(46, 125, 50, 0.15))',
      textPrimary: '#ffffff',
      textSecondary: '#c8e6c9',
      accent: '#81c784'
    },
    
    // 🟣 高端紫主题 - 高端商务风格
    premiumPurple: {
      name: '高端紫',
      background: 'linear-gradient(135deg, #4a148c 0%, #6a1b9a 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(156, 39, 176, 0.2), rgba(106, 27, 154, 0.15))',
      textPrimary: '#ffffff',
      textSecondary: '#e1bee7',
      accent: '#ba68c8'
    },
    
    // ⚫ 暗夜模式 - 护眼深色主题
    darkMode: {
      name: '暗夜模式',
      background: 'linear-gradient(135deg, #000000 0%, #212121 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(255,255,255,0.05), rgba(255,255,255,0.02))',
      textPrimary: '#ffffff',
      textSecondary: '#b0bec5',
      accent: '#90caf9'
    },
    
    // ⚪ 浅色模式 - 简洁明亮主题
    lightMode: {
      name: '浅色模式',
      background: 'linear-gradient(135deg, #fafafa 0%, #e0e0e0 100%)',
      cardBackground: 'linear-gradient(145deg, rgba(255,255,255,0.9), rgba(245,245,245,0.8))',
      textPrimary: '#212121',
      textSecondary: '#757575',
      accent: '#1976d2'
    }
  }
}
```

#### 主题配置方法

**在 app-config.js 中设置应用主题**
```javascript
// 修改 config/app-config.js 文件
theme: {
  currentTheme: 'techBlue', // 设置为科技蓝主题
  // 或者使用其他主题：
  // currentTheme: 'industrialOrange', // 工业橙主题
  // currentTheme: 'ecoGreen',        // 环保绿主题
  // currentTheme: 'premiumPurple',   // 高端紫主题
  // currentTheme: 'darkMode',        // 暗夜模式
  // currentTheme: 'lightMode',       // 浅色模式
  // ... 其他配置
}
```

**通过配置管理器API动态设置**
```javascript
// 在 JavaScript 代码中动态切换主题
const configManager = require('./utils/configManager')

// 切换到指定主题
configManager.switchTheme('industrialOrange')

// 获取当前主题
const currentTheme = configManager.getCurrentTheme()

// 获取可用主题列表
const themes = configManager.getAvailableThemes()
```

#### 自定义主题创建

开发者可以创建自己的主题配色方案：

```javascript
themes: {
  // 添加您的自定义主题
  myCustomTheme: {
    name: '我的主题',
    background: 'linear-gradient(135deg, #your-color1, #your-color2)',
    cardBackground: 'linear-gradient(145deg, rgba(r,g,b,0.2), rgba(r,g,b,0.15))',
    textPrimary: '#ffffff',
    textSecondary: '#your-secondary-color',
    accent: '#your-accent-color',
    navbarBackground: 'rgba(r,g,b,0.6)',
    overlayBackground: 'rgba(r,g,b,0.3)'
  }
}
```

> **注意**: 主题配置是开发者级别的设置，用户无法在应用内更改主题。这确保了应用界面的一致性和品牌形象的统一。

### 4. 高级主题配置

#### 颜色主题

```javascript
theme: {
  // 按钮颜色配置
  buttonColors: {
    green: "#4CAF50",   // 启动按钮
    red: "#F44336",     // 停止按钮
    blue: "#2196F3",    // 功能按钮
    yellow: "#FFC107",  // 警告按钮
    brown: "#795548",   // 暂停按钮
    gray: "#9E9E9E",    // 普通按钮
    white: "#FFFFFF",   // 白色按钮
    purple: "#9C27B0",  // 紫色按钮
    orange: "#FF5722",  // 橙色按钮
    teal: "#009688"     // 青色按钮
  }
}
```

#### 背景图片和特效

```javascript
theme: {
  backgroundImage: "/static/your-background.jpg", // 背景图片
  glassEffect: {
    backdropFilter: "blur(15rpx)",        // 模糊效果强度
    border: "1rpx solid rgba(255,255,255,0.1)", // 边框样式
    shadow: "0 8rpx 32rpx rgba(0,0,0,0.3)"      // 阴影效果
  },
  
  // 主题切换动画
  transition: {
    duration: '0.3s',     // 切换动画时长
    easing: 'ease-in-out' // 动画缓动函数
  }
}
```

## ⌨️ 按键布局自定义

### 1. 网格布局配置

```javascript
buttonLayout: {
  gridColumns: 6,        // 网格列数
  gridGap: "8px",       // 按键间距
  buttonHeight: "60px", // 按键高度
  buttons: [
    // 按键配置数组
  ]
}
```

### 2. 按键类型

#### 文字按钮

```javascript
{
  text: "开始",          // 按钮文字
  type: "green",         // 按钮类型/颜色
  action: "start",       // 按钮动作
  icon: "▶️",           // 可选图标
  showFn: false         // 是否显示Fn标识
}
```

#### 方向箭头按钮

```javascript
{
  arrow: true,          // 标识为箭头按钮
  type: "white",        // 按钮颜色
  rotation: 0,          // 旋转角度 (0=上, 90=右, 180=下, -90=左)
  action: "moveUp"      // 移动动作
}
```

#### Z轴控制按钮

```javascript
{
  zAxis: true,          // 标识为Z轴按钮
  type: "gray",         // 按钮颜色
  rotation: 0,          // 箭头方向 (0=上, 180=下)
  action: "zUp"         // Z轴动作
}
```

#### 自定义样式按钮

```javascript
{
  text: "自定义",
  type: "blue",
  action: "custom",
  customStyle: "background: linear-gradient(45deg, #FF6B6B, #4ECDC4);"
}
```

### 3. 完整按键布局示例

```javascript
buttonLayout: {
  gridColumns: 6,
  buttons: [
    // 第一行 - 设备控制
    { text: "开始", type: "green", action: "start", icon: "▶️" },
    { text: "暂停", type: "brown", action: "pause", icon: "⏸️" },
    { text: "继续", type: "blue", action: "continue", icon: "⏯️" },
    { text: "停止", type: "red", action: "stop", icon: "⏹️" },
    { text: "复位", type: "gray", action: "reset", icon: "🔄" },
    { text: "回零", type: "blue", action: "home", icon: "🏠" },
    
    // 第二行 - 自定义功能
    { text: "吹气", type: "white", action: "blow", icon: "💨" },
    { text: "跟随", type: "white", action: "follow", icon: "👥" },
    { text: "清除\n报警", type: "white", action: "clearAlarm", icon: "🔔" },
    { text: "红光", type: "white", action: "redLight", icon: "🔴" },
    { text: "激光", type: "yellow", action: "laser", icon: "🔆" },
    { text: "工具", type: "blue", action: "tools", icon: "🔧" },
    
    // 第三行 - 方向控制
    { text: "", type: "gray" }, // 空白按钮
    { arrow: true, type: "white", rotation: 0, action: "moveUp" },
    { text: "", type: "gray" },
    { zAxis: true, type: "gray", rotation: 0, action: "zUp" },
    { text: "高速", type: "yellow", action: "highSpeed", icon: "⚡" },
    { text: "", type: "gray" },
    
    // 第四行 - 方向控制
    { arrow: true, type: "white", rotation: -90, action: "moveLeft" },
    { text: "工作\n零点", type: "blue", action: "workZero", showFn: true },
    { arrow: true, type: "white", rotation: 90, action: "moveRight" },
    { zAxis: true, type: "gray", rotation: 180, action: "zDown" },
    { text: "低速", type: "gray", action: "lowSpeed", icon: "🐌" },
    { text: "步进", type: "gray", action: "step", icon: "📏" },
    
    // 第五行 - 扩展功能
    { text: "", type: "gray" },
    { arrow: true, type: "white", rotation: 180, action: "moveDown" },
    { text: "", type: "gray" },
    { text: "标定", type: "gray", action: "calibrate", icon: "🎯" },
    { text: "寻边", type: "blue", action: "findEdge", showFn: true, icon: "🔍" },
    { text: "走边框", type: "blue", action: "walkBorder", showFn: true, icon: "⭕" }
  ]
}
```

## 🔧 动作映射配置

### 1. 动作类型

#### API调用动作

```javascript
actionMapping: {
  start: {
    type: "api",                    // API调用类型
    method: "startMachine",         // API方法名
    successMessage: "设备已启动",   // 成功提示
    confirmRequired: false          // 是否需要确认
  }
}
```

#### 持续动作（按住执行）

```javascript
moveUp: {
  type: "continuous",             // 持续动作类型
  startMethod: "moveAxisUp",      // 开始方法
  stopMethod: "stopAxis",         // 停止方法
  stopParams: [1],               // 停止方法参数
  successMessage: "Y轴上移"
}
```

#### 切换状态动作

```javascript
highSpeed: {
  type: "toggle",                 // 切换类型
  property: "isRapidMode",        // 要切换的属性
  value: true,                    // 设置的值
  successMessage: "高速模式"
}
```

#### 菜单显示动作

```javascript
step: {
  type: "menu",                   // 菜单类型
  method: "showStepMenu",         // 显示菜单的方法
  successMessage: ""
}
```

#### 自定义动作

```javascript
customBlow: {
  type: "custom",                 // 自定义类型
  method: "customBlow",           // 自定义方法名
  successMessage: "吹气功能执行",
  confirmRequired: true,
  confirmMessage: "确定要执行吹气功能吗？"
}
```

### 2. 完整动作映射示例

```javascript
actionMapping: {
  // 设备基础控制
  start: { type: "api", method: "startMachine", successMessage: "设备启动" },
  pause: { type: "api", method: "pauseMachine", successMessage: "设备暂停" },
  continue: { type: "api", method: "continueMachine", successMessage: "设备继续" },
  stop: { 
    type: "api", 
    method: "stopMachine", 
    successMessage: "设备停止",
    additionalActions: ["stopAllAxes"] // 附加动作
  },
  
  // 运动控制
  moveUp: { type: "continuous", startMethod: "moveAxisUp", stopMethod: "stopAxis", stopParams: [1] },
  moveDown: { type: "continuous", startMethod: "moveAxisDown", stopMethod: "stopAxis", stopParams: [1] },
  moveLeft: { type: "continuous", startMethod: "moveAxisLeft", stopMethod: "stopAxis", stopParams: [0] },
  moveRight: { type: "continuous", startMethod: "moveAxisRight", stopMethod: "stopAxis", stopParams: [0] },
  
  // 速度控制
  highSpeed: { type: "toggle", property: "isRapidMode", value: true, successMessage: "高速模式" },
  lowSpeed: { type: "toggle", property: "isRapidMode", value: false, successMessage: "低速模式" },
  
  // 功能菜单
  step: { type: "menu", method: "showStepMenu" },
  
  // 自定义功能
  blow: { type: "custom", method: "customBlow", successMessage: "吹气功能执行" },
  follow: { type: "custom", method: "customFollow", successMessage: "跟随功能执行" }
}
```

## 🔌 API端点配置

### 1. 基础API配置

```javascript
apiConfig: {
  basePath: "/api/v1",            // API基础路径
  timeout: 5000,                  // 请求超时时间
  endpoints: {
    // 设备控制端点
    start: "/machine/start",       // 启动设备
    pause: "/machine/pause",       // 暂停设备
    stop: "/machine/stop",         // 停止设备
    reset: "/machine/reset",       // 重置设备
    
    // 运动控制端点
    moveAxis: "/motion/move",      // 轴移动
    stopAxis: "/motion/stop",      // 停止轴
    homeAxis: "/motion/home",      // 回原点
    
    // 状态查询端点
    status: "/status",             // 设备状态
    health: "/api/health"              // 健康检查
  }
}
```

## 最近更新 / Recent Updates

### 左上角菜单按钮优化 (Menu Button Optimization)

**问题描述 / Issue Description:**
- 左上角菜单按钮太靠近状态栏，导致点击区域不够大，用户难以点击

**解决方案 / Solution:**
1. **增加点击区域**: 将菜单按钮的 `padding` 从 `10rpx` 增加到 `20rpx`，并设置最小宽高为 `80rpx`
2. **动态状态栏适配**: 导航栏位置现在会根据设备的状态栏高度动态调整，避免与状态栏重叠
3. **视觉反馈增强**: 添加了点击时的背景色变化和轻微缩放效果，提升用户体验
4. **响应式布局**: 主内容区域和其他相关元素的位置都会根据实际状态栏高度自动调整

**技术实现 / Technical Implementation:**
- 使用 `wx.getSystemInfoSync()` 获取设备状态栏高度
- 通过内联样式动态设置导航栏和内容区域的位置
- CSS增强了菜单按钮的交互效果和可点击区域